/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db;

import de.akquinet.jbosscc.needle.db.DatabaseTestcaseConfiguration;
import de.akquinet.jbosscc.needle.db.EntityManagerFactoryProvider;
import de.akquinet.jbosscc.needle.db.EntityManagerProvider;
import de.akquinet.jbosscc.needle.db.EntityTransactionProvider;
import de.akquinet.jbosscc.needle.db.TransactionHelperProvider;
import de.akquinet.jbosscc.needle.db.operation.DBOperation;
import de.akquinet.jbosscc.needle.db.transaction.TransactionHelper;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionTargetInformation;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;

public class DatabaseTestcase
implements InjectionProvider<Object> {
    private final DatabaseTestcaseConfiguration configuration;
    private TransactionHelper transactionHelper;
    private DBOperation dbOperation;
    private Map<Class<?>, InjectionProvider<?>> injectionProviderMap = new HashMap();

    public DatabaseTestcase() {
        this.injectionProviderMap.put(EntityManager.class, new EntityManagerProvider(this));
        this.injectionProviderMap.put(EntityManagerFactory.class, new EntityManagerFactoryProvider(this));
        this.injectionProviderMap.put(EntityTransaction.class, new EntityTransactionProvider(this));
        this.injectionProviderMap.put(TransactionHelper.class, new TransactionHelperProvider(this));
        this.configuration = new DatabaseTestcaseConfiguration();
    }

    public DatabaseTestcase(DBOperation dbOperation) {
        this();
        this.dbOperation = dbOperation;
    }

    public DatabaseTestcase(String persistenceUnitName) {
        this.injectionProviderMap.put(EntityManager.class, new EntityManagerProvider(this));
        this.injectionProviderMap.put(EntityManagerFactory.class, new EntityManagerFactoryProvider(this));
        this.injectionProviderMap.put(EntityTransaction.class, new EntityTransactionProvider(this));
        this.injectionProviderMap.put(TransactionHelper.class, new TransactionHelperProvider(this));
        this.configuration = new DatabaseTestcaseConfiguration(persistenceUnitName);
    }

    public DatabaseTestcase(String persistenceUnitName, DBOperation dbOperation) {
        this(persistenceUnitName);
        this.dbOperation = dbOperation;
    }

    @Deprecated
    public DatabaseTestcase(Class<?> ... clazzes) {
        this.injectionProviderMap.put(EntityManager.class, new EntityManagerProvider(this));
        this.injectionProviderMap.put(EntityManagerFactory.class, new EntityManagerFactoryProvider(this));
        this.injectionProviderMap.put(EntityTransaction.class, new EntityTransactionProvider(this));
        this.injectionProviderMap.put(TransactionHelper.class, new TransactionHelperProvider(this));
        this.configuration = new DatabaseTestcaseConfiguration(clazzes);
    }

    @Deprecated
    public DatabaseTestcase(DBOperation dbOperation, Class<?> ... clazzes) {
        this(clazzes);
        this.dbOperation = dbOperation;
    }

    protected void after() throws Exception {
        DBOperation operation = this.getDBOperation();
        if (operation != null) {
            operation.tearDownOperation();
        }
        this.getEntityManager().clear();
    }

    protected void before() throws Exception {
        DBOperation operation = this.getDBOperation();
        if (operation != null) {
            operation.setUpOperation();
        }
    }

    private DBOperation getDBOperation() {
        return this.dbOperation != null ? this.dbOperation : this.configuration.getDBOperation();
    }

    public EntityManager getEntityManager() {
        return this.configuration.getEntityManager();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.configuration.getEntityManagerFactory();
    }

    public TransactionHelper getTransactionHelper() {
        if (this.transactionHelper == null) {
            this.transactionHelper = new TransactionHelper(this.getEntityManager());
        }
        return this.transactionHelper;
    }

    @Override
    public Object getInjectedObject(Class<?> injectionPointType) {
        return this.getInjectionProvider(injectionPointType).getInjectedObject(injectionPointType);
    }

    @Override
    public boolean verify(InjectionTargetInformation injectionTargetInformation) {
        InjectionProvider<?> injectionProvider = this.getInjectionProvider(injectionTargetInformation.getType());
        return injectionProvider != null && injectionProvider.verify(injectionTargetInformation);
    }

    @Override
    public Object getKey(InjectionTargetInformation injectionTargetInformation) {
        return this.getInjectionProvider(injectionTargetInformation.getType()).getKey(injectionTargetInformation);
    }

    private InjectionProvider<?> getInjectionProvider(Class<?> type) {
        return this.injectionProviderMap.get(type);
    }
}

