/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db;

import de.akquinet.jbosscc.needle.configuration.NeedleConfiguration;
import de.akquinet.jbosscc.needle.db.configuration.PersistenceConfigurationFactory;
import de.akquinet.jbosscc.needle.db.operation.AbstractDBOperation;
import de.akquinet.jbosscc.needle.db.operation.DBOperation;
import de.akquinet.jbosscc.needle.db.operation.JdbcConfiguration;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatabaseTestcaseConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseTestcaseConfiguration.class);
    private static final String JDBC_DRIVER_KEY = "javax.persistence.jdbc.driver";
    private static final String JDBC_URL_KEY = "javax.persistence.jdbc.url";
    private static final String JDBC_USER_KEY = "javax.persistence.jdbc.user";
    private static final String JDBC_PASSWORD_KEY = "javax.persistence.jdbc.password";
    private static final Class<? extends AbstractDBOperation> DB_OPERATION_CLASS = DatabaseTestcaseConfiguration.lookupDBOperationClass(NeedleConfiguration.getDBOperationClassName());
    private final AbstractDBOperation dbOperation;
    private final PersistenceConfigurationFactory configuration;

    private DatabaseTestcaseConfiguration(PersistenceConfigurationFactory configuratiorn) {
        this.configuration = configuratiorn;
        this.dbOperation = this.createDBOperation(DB_OPERATION_CLASS);
    }

    DatabaseTestcaseConfiguration(Class<?> ... clazzes) {
        this(new PersistenceConfigurationFactory(clazzes));
    }

    DatabaseTestcaseConfiguration(String persistenceUnitName) {
        this(new PersistenceConfigurationFactory(persistenceUnitName));
    }

    DatabaseTestcaseConfiguration() {
        this(NeedleConfiguration.getPersistenceunitName());
    }

    EntityManager getEntityManager() {
        return this.configuration.getEntityManager();
    }

    EntityManagerFactory getEntityManagerFactory() {
        return this.configuration.getEntityManagerFactory();
    }

    DBOperation getDBOperation() {
        return this.dbOperation;
    }

    AbstractDBOperation createDBOperation(Class<? extends AbstractDBOperation> dbOperationClass) {
        if (dbOperationClass != null) {
            try {
                return ReflectionUtil.createInstance(dbOperationClass, this.getJdbcComfiguration());
            }
            catch (Exception e) {
                LOG.warn("could not create a new instance of configured db operation {}, {}", dbOperationClass, (Object)e.getMessage());
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        } else {
            LOG.info("no db operation configured");
        }
        return null;
    }

    static Class<? extends AbstractDBOperation> lookupDBOperationClass(String dbOperation) {
        try {
            if (dbOperation != null) {
                return Class.forName(dbOperation);
            }
        }
        catch (Exception e) {
            LOG.warn("error while loading db operation class {}, {}", (Object)dbOperation, (Object)e.getMessage());
        }
        return null;
    }

    private JdbcConfiguration getJdbcComfiguration() throws Exception {
        if (NeedleConfiguration.getJdbcDriver() != null && NeedleConfiguration.getJdbcUrl() != null) {
            return new JdbcConfiguration(NeedleConfiguration.getJdbcUrl(), NeedleConfiguration.getJdbcDriver(), NeedleConfiguration.getJdbcUser(), NeedleConfiguration.getJdbcPassword());
        }
        return this.getEntityManagerFactoryProperties();
    }

    private JdbcConfiguration getEntityManagerFactoryProperties() throws Exception {
        try {
            Map properties = this.getEntityManagerFactory().getProperties();
            return new JdbcConfiguration((String)properties.get(JDBC_URL_KEY), (String)properties.get(JDBC_DRIVER_KEY), (String)properties.get(JDBC_USER_KEY), (String)properties.get(JDBC_PASSWORD_KEY));
        }
        catch (Exception e) {
            throw new Exception("error while loading jdbc configuration properties form EntityManagerFactory", e);
        }
    }
}

