package de.almostintelligent.jaste;

import de.almostintelligent.jaste.config.Configuration;
import de.almostintelligent.jaste.config.ConfigurationInitializer;
import de.almostintelligent.jaste.resolver.BasicResolver;

public final class ResolverFactory {
	
	private static ResolverFactory INSTANCE = new ResolverFactory();
	private final Configuration cfg = new Configuration();
	
	static {
		INSTANCE.init();
	}
	
	private ResolverFactory() {
	}
	
	private void init() {
		new ConfigurationInitializer(cfg).configure();
	}
	
	private Resolver create() {
		return new BasicResolver(cfg);
	}
	
	public static Resolver createResolver() {
		return INSTANCE.create();
	}
	
	public static Configuration getConfiguration() {
		return INSTANCE.cfg;
	}
}
