package de.almostintelligent.jaste;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.almostintelligent.jaste.config.Configuration;
import de.almostintelligent.jaste.config.Configured;
import de.almostintelligent.jaste.error.JaSTEException;
import de.almostintelligent.jaste.token.Token;

public final class Template implements Configured {

	private static Logger logger = LoggerFactory.getLogger(Template.class);
	
	private Configuration cfg;
	
    private List<Token> token;
    
    public Template(Configuration cfg, List<Token> token) {
    	this.cfg = cfg;
    	this.token = token;
    }
    
    public void render(Map<String, ?> mapping, Writer out) throws JaSTEException {
    	if(token == null) {
    		logger.error("Tokenlist must not be null.");
    	} else {
	    	try {
		    	for(Token t:token) {
					t.render(mapping, out);
		    	}
			} catch (IOException e) {
				logger.error(e.getMessage());
			}
    	}
    }
    
    public String render(Map<String, Object> mapping) throws JaSTEException {
    	StringWriter buffer = new StringWriter();
    	this.render(mapping, buffer);
    	return buffer.toString();
    }

	public void render(HashMap<String, Object> mapping, OutputStream out) throws JaSTEException {
		this.render(mapping, new OutputStreamWriter(out));
	}

	@Override
	public Configuration getConfiguration() {
		return this.cfg;
	}
}
