package de.almostintelligent.jaste.config;

import de.almostintelligent.jaste.loader.TemplateLoader;
import de.almostintelligent.jaste.parser.BasicParser;
import de.almostintelligent.jaste.parser.Parser;

/**
 * 
 * @author Chris
 *
 */
public class Configuration {
	
	/**
	 * Current token start delimiter.
	 */
	private String delimiterStart 	= "{{";
	/**
	 * Current token end delimiter.
	 */
	private String delimiterEnd		= "}}";
	
	private TemplateLoader loader;
	/**
	 * @return current token start delimiter. 
	 */
	public String getDelimiterStart() {
		return delimiterStart;
	}
	
	/**
	 * Sets a new token start delimiter.
	 * @param delimiterStart must not be null or empty string.
	 */
	public void setDelimiterStart(String delimiterStart) {
		if(delimiterStart != null && !delimiterStart.equals("")) {
			this.delimiterStart = delimiterStart;
		}
	}
	/**
	 * @return current token end delimiter.
	 */
	public String getDelimiterEnd() {
		return delimiterEnd;
	}
	/**
	 * Sets a new token end delimiter.
	 * @param delimiterEnd must not be null or empty string.
	 */
	public void setDelimiterEnd(String delimiterEnd) {
		if(delimiterEnd != null && !delimiterEnd.equals("")) {
			this.delimiterEnd = delimiterEnd;
		}
	}
	
	public Parser getParser() {
		return new BasicParser(this);
	}

	/**
	 * @return the loader
	 */
	public TemplateLoader getLoader() {
		return loader;
	}

	/**
	 * @param loader the loader to set
	 */
	public void setLoader(TemplateLoader loader) {
		this.loader = loader;
	}
}
