package de.almostintelligent.jaste.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import javax.servlet.ServletContext;

public class ContextTemplateLoader implements TemplateLoader {

	private ServletContext ctx;
	
	private String prefix;
	private String suffix;
	
	public ContextTemplateLoader(ServletContext ctx) {
		this.ctx = ctx;
		this.prefix="";
		this.suffix="";
	}
	
	@Override
	public Reader getReader(String name) throws IOException {
		InputStream is = ctx.getResourceAsStream(prefix + name + suffix);
		if(is == null) {
			throw new IOException("Could not find resource: "+prefix + name + suffix);
		}
		return new InputStreamReader(is);
	}

	public void setPrefix(String pre) {
		prefix = pre;
	}
	
	public void setSuffix(String suf) {
		suffix = suf;
	}
}
