package de.almostintelligent.jaste.loader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class StringTemplateLoader implements TemplateLoader {

	private Map<String, String> templates;
	
	public StringTemplateLoader() {
		templates = new HashMap<>();
	}
	
	@Override
	public Reader getReader(String name) throws IOException {
		String t = templates.get(name);
		if(t == null) {
			throw new IOException("Template not found: " + name);
		}
		return new StringReader(t);
	}
	
	public void addTemplate(String name, String template) {
		if(name!=null && template!=null) {
			templates.put(name, template);
		}
	}

}
