package de.almostintelligent.jaste.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.almostintelligent.jaste.Template;
import de.almostintelligent.jaste.config.Configuration;
import de.almostintelligent.jaste.error.JaSTEParserException;
import de.almostintelligent.jaste.token.BasicTokenFactory;
import de.almostintelligent.jaste.token.Token;
import de.almostintelligent.jaste.token.TokenFactory;

public class BasicParser implements Parser {

	private static Logger logger = LoggerFactory.getLogger(BasicParser.class);
	
	private Configuration cfg;
	
	public BasicParser(Configuration cfg) {
		this.cfg = cfg;
	}
	
	@Override
	public Template parseTemplate(Reader in) throws JaSTEParserException {
		if(in == null) {
			throw new JaSTEParserException("Reader must not be null.");
		}
		String sd = cfg.getDelimiterStart();
		String ed = cfg.getDelimiterEnd();
		Reader reader;
		if(in.markSupported()) {
			reader = in;
		} else {
			reader = new BufferedReader(in);
		}	
		return new Template(cfg, parse(reader,sd,ed));

	}
	
	private List<Token> parse(Reader reader, String sd, String ed) throws JaSTEParserException {
        boolean token = false;
        List<Token> tokens = new LinkedList<>();
        StringBuilder sb = new StringBuilder();
        TokenFactory tf = new BasicTokenFactory();
		try {
            int c;
            while((c=reader.read())!=-1) {
            	//start delimiter
            	if(c == sd.charAt(0)) {
            		reader.mark(sd.length()-1);
            		boolean check = true;
            		for(int i=0;i<sd.length()-1; i++) {
            			if(sd.charAt(1+i)!=reader.read()) {
            				check = false;
            			}
            		}
            		if(!check) {
            			reader.reset();
            			sb.append((char)c);
            		} else if(token) {
            			throw new JaSTEParserException("Token start delimiter found in already started token.");
            		} else {
            			logger.debug("start delimiter found.");
            			token = true;
            			tokens.add(tf.createConstToken(sb.toString()));
            			sb.setLength(0);
            		}
            	//end delimiter
            	} else if (c == ed.charAt(0) && token) {
            		reader.mark(ed.length()-1);
            		boolean check = true;
            		for(int i=0; i<ed.length()-1; i++) {
            			if(ed.charAt(1+i)!=reader.read()) {
            				check = false;
            			}
            		}
            		if(!check) {
            			reader.reset();
            			sb.append((char)c);
            		} else {
            			logger.debug("end delimiter found.");
            			token = false;
            			tokens.add(tf.createVarToken(sb.toString()));
            			sb.setLength(0);
            		}
            	//other characters
            	} else {
            		sb.append((char)c);
            	}
            }
            if(token) {
            	throw new JaSTEParserException("Found EOF before token end delimiter.");
            }
            if(sb.length()>0) {
            	tokens.add(tf.createConstToken(sb.toString()));
            }
            return tokens;
        } catch (IOException e) {
            throw new JaSTEParserException(e.getMessage());
        }
	}

	@Override
	public Configuration getConfiguration() {
		return this.cfg;
	}

}
