package de.almostintelligent.jaste.resolver;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.almostintelligent.jaste.Template;
import de.almostintelligent.jaste.Resolver;
import de.almostintelligent.jaste.config.Configuration;
import de.almostintelligent.jaste.error.JaSTEException;
import de.almostintelligent.jaste.loader.TemplateLoader;
import de.almostintelligent.jaste.parser.Parser;

public class BasicResolver implements Resolver {
	private static Logger logger = LoggerFactory.getLogger(BasicResolver.class);
	
	private Configuration cfg;
	
	private Parser parser;
	
	private Boolean caching = true;
	
	private Map<String, Template> cache = new  HashMap<>();
	
	public BasicResolver(Configuration cfg) {
		this.cfg = cfg;
		parser = cfg.getParser();
	}
	
	@Override
	public Template getTemplate(String pagename, Locale locale) throws JaSTEException {
		if(caching = true) {
			Template t = cache.get(pagename);
			if(t!=null) {
				return t;
			}
		}
		Reader in;
		try {
			in = cfg.getLoader().getReader(pagename);
			return parser.parseTemplate(in);
		} catch (IOException e) {
			logger.error(e.getMessage());
			throw new JaSTEException(e.getMessage());
		}
		
	}

	@Override
	public Template getTemplate(String name) throws JaSTEException {
		return this.getTemplate(name, null);
	}

	@Override
	public Configuration getConfiguration() {
		return cfg;
	}

	@Override
	public void setConfiguration(Configuration cfg) {
		this.cfg = cfg;
	}
	
	@Override
	public void setLoader(TemplateLoader loader) {
		this.cfg.setLoader(loader);
	}
	
	/**
	 * @return the caching
	 */
	public Boolean isCaching() {
		return caching;
	}

	/**
	 * @param caching the caching to set
	 */
	public void setCaching(Boolean caching) {
		this.caching = caching;
	}



}
