package de.almostintelligent.jaste.spring;

import java.util.Locale;

import javax.servlet.ServletContext;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

import de.almostintelligent.jaste.Resolver;
import de.almostintelligent.jaste.ResolverFactory;
import de.almostintelligent.jaste.Template;
import de.almostintelligent.jaste.loader.ContextTemplateLoader;

public class JaSTEViewResolver implements ViewResolver, InitializingBean, ServletContextAware {
	private Resolver resolver;
	private String prefix;
	private String suffix;
	private ServletContext ctx;
	
	@Override
	public View resolveViewName(String viewName, Locale locale)
			throws Exception {
		Template t = resolver.getTemplate(viewName, locale);
		if(t == null) {
			return null;
		}
		return new JaSTEView(t);
	}
	
	public void setPrefix(String pre) {
		prefix = pre;
	}
	
	public void setSuffix(String suf) {
		suffix = suf;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		resolver = ResolverFactory.createResolver();
		ContextTemplateLoader ctl = new ContextTemplateLoader(ctx);
		ctl.setPrefix(prefix);
		ctl.setSuffix(suffix);
		resolver.setLoader(ctl);
	}

	@Override
	public void setServletContext(ServletContext servletContext) {
		ctx = servletContext;
	}

}
