package de.almostintelligent.jaste.token;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VarToken implements Token {
	
	private String varname;
	
	private static Logger logger = LoggerFactory.getLogger(VarToken.class);
	
	public VarToken(String var) {
		this.varname=var;
	}

	@Override
	public void render(Map<String, ?> mapping, Writer out)
			throws IOException {
		if(mapping != null) {
			Object obj = mapping.get(varname);
			if(obj!=null) {
				out.write(obj.toString());
			} else {
				logger.debug("Could not find '{}' in mapping.", varname);
			}
		} else {
			logger.error("Mapping must not be null.");
		}
	}

}
