/*
 * Decompiled with CFR 0.152.
 */
package de.almostintelligent.jaste.resolver;

import de.almostintelligent.jaste.Resolver;
import de.almostintelligent.jaste.Template;
import de.almostintelligent.jaste.config.Configuration;
import de.almostintelligent.jaste.error.JaSTEException;
import de.almostintelligent.jaste.loader.TemplateLoader;
import de.almostintelligent.jaste.parser.Parser;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicResolver
implements Resolver {
    private static Logger logger = LoggerFactory.getLogger(BasicResolver.class);
    private Configuration cfg;
    private Parser parser;
    private Boolean caching = true;
    private Map<String, Template> cache = new HashMap<String, Template>();

    public BasicResolver(Configuration cfg) {
        this.cfg = cfg;
        this.parser = cfg.getParser();
    }

    @Override
    public Template getTemplate(String pagename, Locale locale) throws JaSTEException {
        Template t;
        this.caching = true;
        if (this.caching.booleanValue() && (t = this.cache.get(pagename)) != null) {
            return t;
        }
        try {
            Reader in = this.cfg.getLoader().getReader(pagename);
            return this.parser.parseTemplate(in);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new JaSTEException(e.getMessage());
        }
    }

    @Override
    public Template getTemplate(String name) throws JaSTEException {
        return this.getTemplate(name, null);
    }

    @Override
    public Configuration getConfiguration() {
        return this.cfg;
    }

    @Override
    public void setConfiguration(Configuration cfg) {
        this.cfg = cfg;
    }

    @Override
    public void setLoader(TemplateLoader loader) {
        this.cfg.setLoader(loader);
    }

    public Boolean isCaching() {
        return this.caching;
    }

    public void setCaching(Boolean caching) {
        this.caching = caching;
    }
}

