/*
 * Decompiled with CFR 0.152.
 */
package de.almostintelligent.jaste.spring;

import de.almostintelligent.jaste.Resolver;
import de.almostintelligent.jaste.ResolverFactory;
import de.almostintelligent.jaste.Template;
import de.almostintelligent.jaste.loader.ContextTemplateLoader;
import de.almostintelligent.jaste.spring.JaSTEView;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class JaSTEViewResolver
implements ViewResolver,
InitializingBean,
ServletContextAware {
    private Resolver resolver;
    private String prefix;
    private String suffix;
    private ServletContext ctx;

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        Template t = this.resolver.getTemplate(viewName, locale);
        if (t == null) {
            return null;
        }
        return new JaSTEView(t);
    }

    public void setPrefix(String pre) {
        this.prefix = pre;
    }

    public void setSuffix(String suf) {
        this.suffix = suf;
    }

    public void afterPropertiesSet() throws Exception {
        this.resolver = ResolverFactory.createResolver();
        ContextTemplateLoader ctl = new ContextTemplateLoader(this.ctx);
        ctl.setPrefix(this.prefix);
        ctl.setSuffix(this.suffix);
        this.resolver.setLoader(ctl);
    }

    public void setServletContext(ServletContext servletContext) {
        this.ctx = servletContext;
    }
}

