/*
 * Decompiled with CFR 0.152.
 */
package address.book.application.geocoding;

import java.util.Map;
import org.jgeohash.GeoHashUtils;
import org.jgeohash.Point;
import org.jgeohash.api.Position;
import org.jgeohash.distance.DistanceCalculator;
import org.jgeohash.distance.MeasuringUnit;

public class GeoLocationService {
    private static double EARTH_RADIUS_KM = 6371.009;
    public static final double DIAMETER_OF_EARTH = 6371009.0;

    public static void main(String[] args) {
        String alterTeichwegGeohash = "u1x0v54r";
        Map neighbors = GeoHashUtils.getAllAdjacentAreasMap((String)alterTeichwegGeohash);
        System.out.println("neighbors:" + neighbors);
        double[] coordinates = GeoHashUtils.decodeAndRound((String)alterTeichwegGeohash);
        Point alterTeichweg = new Point(coordinates[0], coordinates[1]);
        Point ludwigsburg = new Point(48.894169, 9.19187);
        for (Point point : GeoLocationService.getExtremePointsFrom(ludwigsburg, 300.0)) {
            System.out.println("Extreme Point : " + point);
            System.out.println("Distance from point  : " + DistanceCalculator.distanceBetweenPoints((Position)ludwigsburg, (Position)point, (MeasuringUnit)MeasuringUnit.METER));
        }
        double distance1 = DistanceCalculator.distanceBetweenPoints((Position)ludwigsburg, (Position)alterTeichweg, (MeasuringUnit)MeasuringUnit.MILE);
        System.out.println("Distance1:" + distance1);
    }

    private static double radiansToDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    private static double degreesToRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    private static double getExtremeLongitudesDiffForPoint(Point p1, double distance) {
        double lat1 = p1.getLatitude();
        lat1 = GeoLocationService.degreesToRadians(lat1);
        double longitudeRadius = Math.cos(lat1) * EARTH_RADIUS_KM;
        double diffLong = distance / longitudeRadius;
        diffLong = GeoLocationService.radiansToDegrees(diffLong);
        return diffLong;
    }

    private static double getExtremeLatitudesDiffForPoint(Point p1, double distance) {
        double latitudeRadians = distance / EARTH_RADIUS_KM;
        double diffLat = GeoLocationService.radiansToDegrees(latitudeRadians);
        return diffLat;
    }

    private static Point[] getExtremePointsFrom(Point point, Double distance) {
        double longDiff = GeoLocationService.getExtremeLongitudesDiffForPoint(point, distance);
        double latDiff = GeoLocationService.getExtremeLatitudesDiffForPoint(point, distance);
        Point p1 = new Point(point.getLatitude() - latDiff, point.getLongitude() - longDiff);
        Point p2 = new Point(point.getLatitude() + latDiff, point.getLatitude() + longDiff);
        return new Point[]{p1, p2};
    }
}

