/*
 * Decompiled with CFR 0.152.
 */
package address.book.application.geocoding;

import address.book.application.geocoding.GoogleGeocodingHandler;
import address.book.model.Addresses;
import address.book.model.Zipcodes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jaulp.xml.XmlUtils;
import net.sourceforge.jaulp.xml.sax.handler.BreakParsingException;
import org.jgeohash.GeoHashPoint;
import org.xml.sax.helpers.DefaultHandler;

public class Geocoder {
    public static final String HTTP_MAPS_GOOGLE_COM_MAPS_API_GEOCODE_JSON = "http://maps.google.com/maps/api/geocode/json";
    public static final String HTTP_MAPS_GOOGLE_COM_MAPS_API_GEOCODE_XML = "http://maps.google.com/maps/api/geocode/xml";
    public static final String HTTP_GEOHASH_ORG = "http://geohash.org/";

    public static void setGeocodingData(Addresses address) throws MalformedURLException, IOException {
        String responseFromGoogle = Geocoder.getGeolocationAsXml(address.getStreet() + " " + address.getStreetnumber() + " " + address.getZipcode().getZipcode() + " " + address.getZipcode().getCity());
        GeoHashPoint geoHashModel = Geocoder.getGeocodingData(responseFromGoogle);
        if (geoHashModel != null) {
            address.setGeohash(geoHashModel.getGeohash());
            address.setLatitude(geoHashModel.getLat().toString());
            address.setLongitude(geoHashModel.getLng().toString());
        }
    }

    public static GeoHashPoint getGeocodingData(Zipcodes address) throws MalformedURLException, IOException {
        String responseFromGoogle = Geocoder.getGeolocationAsXml(address.getZipcode() + " " + address.getCity());
        GeoHashPoint geoHashModel = Geocoder.getGeocodingData(responseFromGoogle);
        return geoHashModel;
    }

    public static GeoHashPoint getGeocodingData(String xmldata) {
        GeoHashPoint model = null;
        HashMap<String, String> data = new HashMap<String, String>();
        GoogleGeocodingHandler handler = new GoogleGeocodingHandler(data);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(XmlUtils.getInputSource((String)xmldata), (DefaultHandler)handler);
        }
        catch (Throwable t) {
            if (t instanceof BreakParsingException) {
                System.out.println("Parsing is purposely break.");
            }
            t.printStackTrace();
        }
        if (data.size() == 2) {
            String l = (String)data.get("lat");
            String longtidude = (String)data.get("lng");
            double lat = Double.parseDouble(l);
            double lng = Double.parseDouble(longtidude);
            model = new GeoHashPoint(lat, lng);
        }
        return model;
    }

    public static String getGeolocationAsXml(String address) throws MalformedURLException, IOException {
        String params = Geocoder.getUrlParams(address, false);
        String response = Geocoder.getGoogleXmlResponse(params);
        return response;
    }

    public static String getGoogleXmlResponse(String params) throws MalformedURLException, IOException {
        String line;
        URL url = new URL(HTTP_MAPS_GOOGLE_COM_MAPS_API_GEOCODE_XML + params);
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            sb.append(line + "\n");
        }
        rd.close();
        return sb.toString();
    }

    public static String getJsonResponse(String params) throws MalformedURLException, IOException {
        String line;
        URL url = new URL(HTTP_MAPS_GOOGLE_COM_MAPS_API_GEOCODE_JSON + params);
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            sb.append(line + "\n");
        }
        rd.close();
        return sb.toString();
    }

    public static String getUrlParams(String address, boolean sensor) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("?");
        sb.append(URLEncoder.encode("address", "UTF-8") + "=" + URLEncoder.encode(address, "UTF-8"));
        sb.append("&" + URLEncoder.encode("sensor", "UTF-8") + "=" + URLEncoder.encode(sensor + "", "UTF-8"));
        return sb.toString();
    }

    public static String getUrlParameters(Map<String, String> parameters) throws UnsupportedEncodingException {
        String result = "";
        if (parameters != null && 1 <= parameters.size()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            Set<Map.Entry<String, String>> entries = parameters.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                sb.append(URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8"));
                sb.append("&");
            }
            result = sb.toString().trim().substring(0, sb.toString().trim().length() - 1);
        }
        return result;
    }

    public static String getPlainTextResponse(String geohash) throws MalformedURLException, IOException {
        String line;
        URL url = new URL(HTTP_GEOHASH_ORG + geohash);
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            sb.append(line + "\n");
        }
        rd.close();
        return sb.toString();
    }
}

