/*
 * Decompiled with CFR 0.152.
 */
package address.book.application.geocoding;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jaulp.xml.sax.handler.BreakParsingException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GoogleGeocodingHandler
extends DefaultHandler {
    private Map<String, String> data;
    protected static final String LOCATION = "location";
    public static final String LAT = "lat";
    public static final String LNG = "lng";
    boolean location = false;
    boolean lat = false;
    boolean lng = false;

    public GoogleGeocodingHandler(Map<String, String> data) {
        this.data = data;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: cmd filename");
            System.exit(1);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        GoogleGeocodingHandler handler = new GoogleGeocodingHandler(map);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(args[0]), (DefaultHandler)handler);
        }
        catch (Throwable t) {
            if (t instanceof BreakParsingException) {
                System.out.println("Parsing is purposely break.");
            }
            t.printStackTrace();
        }
        System.out.println(map);
        System.exit(0);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (this.location) {
            if (this.lat) {
                this.data.put(LAT, s);
                this.lat = false;
            }
            if (this.lng) {
                this.data.put(LNG, s);
                this.lng = false;
            }
        }
    }

    @Override
    public void startElement(String namespaceURI, String simpleName, String qualifiedName, Attributes attributes) throws SAXException {
        String elementName = simpleName;
        if ("".equals(elementName)) {
            elementName = qualifiedName;
        }
        if (elementName.equals(LOCATION)) {
            this.location = true;
        }
        if (elementName.equals(LAT)) {
            this.lat = true;
        }
        if (elementName.equals(LNG)) {
            this.lng = true;
        }
        if (elementName.equals("location_type")) {
            throw new BreakParsingException("Stopped Parsing file...");
        }
    }
}

