/*
 * Decompiled with CFR 0.152.
 */
package address.book.service;

import address.book.daos.AddressesDao;
import address.book.factories.AddressBookFactory;
import address.book.model.Addresses;
import address.book.model.Countries;
import address.book.model.Federalstates;
import address.book.model.Zipcodes;
import address.book.service.api.AddressesService;
import address.book.service.api.FederalstatesService;
import address.book.service.api.ZipcodesService;
import address.book.service.utils.HqlStringCreator;
import hbm.dao.jpa.EntityManagerDao;
import hbm.service.jpa.AbstractBusinessService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.jgeohash.GeoHashUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="addressesService")
public class AddressesBusinessService
extends AbstractBusinessService<Addresses, Integer, AddressesDao>
implements AddressesService {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ZipcodesService zipcodesService;
    @Autowired
    private FederalstatesService federalstatesService;

    @Autowired
    public void setAddressesDao(AddressesDao addressesDao) {
        this.setDao((EntityManagerDao)addressesDao);
    }

    @Override
    public Addresses createAddress(String street, String streetnumber, String addressComment, String zipcode, String city, String federalstate) {
        Zipcodes zc = this.zipcodesService.getZipcode(zipcode, city);
        Federalstates federalstates = zc != null && zc.getCountry() != null ? this.federalstatesService.findFederalstate(zc.getCountry(), federalstate) : this.federalstatesService.findFederalstateFromIso3166A2code(federalstate);
        Addresses address = AddressBookFactory.getInstance().newAddresses(addressComment, federalstates, null, null, null, street, streetnumber, zc);
        return address;
    }

    @Override
    public Addresses createAddress(String street, String streetnumber, String addressComment, String zipcode, String city, String federalstate, String geohash, BigDecimal latitude, BigDecimal longitude) {
        Zipcodes zip = this.zipcodesService.getZipcode(zipcode, city);
        Federalstates federalstates = zip != null && zip.getCountry() != null ? this.federalstatesService.findFederalstate(zip.getCountry(), federalstate) : this.federalstatesService.findFederalstateFromIso3166A2code(federalstate);
        Addresses address = AddressBookFactory.getInstance().newAddresses(addressComment, federalstates, geohash, latitude, longitude, street, streetnumber, zip);
        return address;
    }

    @Override
    public List<Addresses> find(String geohash, String latitude, String longitude) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.geohash=:geohash");
        sb.append(" ");
        sb.append("and a.latitude=:latitude");
        sb.append(" ");
        sb.append("and a.longitude=:longitude");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("geohash", (Object)geohash);
        query.setParameter("latitude", (Object)latitude);
        query.setParameter("longitude", (Object)longitude);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Zipcodes> findAllAddressesWithCountry(Countries country) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.zipcode from Addresses a");
        sb.append(" ");
        sb.append("where a.zipcode.country=:country");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("country", (Object)country);
        List zipcodes = query.getResultList();
        return zipcodes;
    }

    @Override
    public List<Addresses> findAll(Countries country) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.zipcode.country=:country");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("country", (Object)country);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> findGeohashIsNull() {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.geohash is null");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> find(String geohash) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.geohash=:geohash");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("geohash", (Object)geohash);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> findNeighbourhood(String geohash) {
        String hqlString = HqlStringCreator.getGeohashQuery();
        Query query = this.getQuery(hqlString);
        query.setParameter("center", (Object)(geohash + "%"));
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> findFirstRingNeighbourhood(String geohash) {
        Map adjacentAreas = null;
        if (geohash != null && !geohash.isEmpty()) {
            adjacentAreas = GeoHashUtils.getAllAdjacentAreasMap((String)geohash);
        }
        String hqlString = HqlStringCreator.getGeohashFirstRingQuery();
        Query query = this.getQuery(hqlString);
        for (Map.Entry entry : adjacentAreas.entrySet()) {
            query.setParameter((String)entry.getKey(), (Object)((String)entry.getValue() + "%"));
        }
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> findFirstAndSecondRingNeighbourhood(String geohash) {
        Map adjacentAreas = null;
        if (geohash != null && !geohash.isEmpty()) {
            adjacentAreas = GeoHashUtils.getTwentyFiveAreasMap((String)geohash);
        }
        String hqlString = HqlStringCreator.getGeohashFirstAndSecondRingQuery();
        Query query = this.getQuery(hqlString);
        for (Map.Entry entry : adjacentAreas.entrySet()) {
            query.setParameter((String)entry.getKey(), (Object)((String)entry.getValue() + "%"));
        }
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> find(String latitude, String longitude) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.latitude=:latitude");
        sb.append(" ");
        sb.append("and a.longitude=:longitude");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("latitude", (Object)latitude);
        query.setParameter("longitude", (Object)longitude);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public Addresses contains(String latitude, String longitude) {
        List<Addresses> addresses = this.find(latitude, longitude);
        if (addresses != null && !addresses.isEmpty()) {
            return addresses.get(0);
        }
        return null;
    }

    @Override
    public Addresses contains(Zipcodes zipcode) {
        List<Addresses> addresses = this.find(zipcode);
        if (addresses != null && !addresses.isEmpty()) {
            return addresses.get(0);
        }
        return null;
    }

    @Override
    public List<Addresses> find(Zipcodes zipcode) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.zipcode=:zipcode");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("zipcode", (Object)zipcode);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> find(Countries country, String zipcode) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.zipcode.country=:country");
        sb.append(" ");
        sb.append("and a.zipcode.zipcode=:zipcode");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("zipcode", (Object)zipcode);
        query.setParameter("country", (Object)country);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> find(Countries country, String zipcode, String city) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.zipcode.country=:country");
        sb.append(" ");
        sb.append("and a.zipcode.zipcode=:zipcode");
        sb.append(" ");
        sb.append("and a.zipcode.city like :city");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("country", (Object)country);
        query.setParameter("zipcode", (Object)zipcode);
        query.setParameter("city", (Object)("%" + city + "%"));
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> findInvalidAddresses(Countries country, String geohash) {
        return this.findInvalidAddresses(country, geohash, true);
    }

    @Override
    public List<Addresses> findInvalidAddresses(Countries country, String geohash, boolean not) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.zipcode.country=:country");
        sb.append(" ");
        sb.append("and a.geohash ");
        if (not) {
            sb.append("not ");
        }
        sb.append("like :geohash");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("country", (Object)country);
        query.setParameter("geohash", (Object)(geohash + "%"));
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> findAddressesWithSameCityname(Countries country, String city) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.zipcode.country=:country");
        sb.append(" ");
        sb.append("and a.zipcode.city=:city");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("country", (Object)country);
        query.setParameter("city", (Object)city);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public List<Addresses> findAddressesWithSameZipcode(Countries country, String zipcode) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a from Addresses a");
        sb.append(" ");
        sb.append("where a.zipcode.country=:country");
        sb.append(" ");
        sb.append("and a.zipcode.zipcode=:zipcode");
        String hqlString = sb.toString();
        Query query = this.getQuery(hqlString);
        query.setParameter("country", (Object)country);
        query.setParameter("zipcode", (Object)zipcode);
        List addresses = query.getResultList();
        return addresses;
    }

    @Override
    public Addresses findFirst(Countries country, String zipcode) {
        List<Addresses> addresses = this.find(country, zipcode);
        if (addresses != null && !addresses.isEmpty()) {
            return addresses.get(0);
        }
        return null;
    }

    public ZipcodesService getZipcodesService() {
        return this.zipcodesService;
    }

    public void setZipcodesService(ZipcodesService zipcodesService) {
        this.zipcodesService = zipcodesService;
    }

    public FederalstatesService getFederalstatesService() {
        return this.federalstatesService;
    }

    public void setFederalstatesService(FederalstatesService federalstatesService) {
        this.federalstatesService = federalstatesService;
    }
}

