package address.book.restful;

import hbm.service.rs.AbstractRestfulResource;

import java.util.Collections;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import address.book.domain.Address;

@Path("/address/")
@Produces("application/json")
public class AddressesResource extends AbstractRestfulResource<Integer, Address> {
	
    @GET
    @Path("/geohash/{geohash}/")
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
	public List<Address> find(@PathParam("geohash")String geohash) {
		return Collections.emptyList();		
	}
    
    @GET
    @Path("/get/{id}")
    @Produces({"application/xml","application/json"})
    @Consumes({"application/xml","application/json","application/x-www-form-urlencoded"})    
    public Address get(String id) {
    	return getBusinessMapperService().read(Integer.valueOf(id));
    }
}
