/*
 * Decompiled with CFR 0.152.
 */
package address.book.application.geocoding;

import address.book.application.geocoding.Geocoder;
import de.alpharogroup.jgeohash.GeoHashUtils;
import de.alpharogroup.jgeohash.Point;
import de.alpharogroup.jgeohash.api.Position;
import de.alpharogroup.jgeohash.distance.DistanceCalculator;
import de.alpharogroup.jgeohash.distance.MeasuringUnit;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;

public class GeoLocationService {
    private static final double EARTH_RADIUS_KM = 6371.009;
    public static final double DIAMETER_OF_EARTH = 6371009.0;

    public static void main(String[] args) {
        String alterTeichwegGeohash = "u1x0v54r";
        Map neighbors = GeoHashUtils.getAllAdjacentAreasMap((String)alterTeichwegGeohash);
        System.out.println("neighbors:" + neighbors);
        double[] coordinates = GeoHashUtils.decodeAndRound((String)alterTeichwegGeohash);
        Point alterTeichweg = new Point(coordinates[0], coordinates[1]);
        Point ludwigsburg = new Point(48.894169, 9.19187);
        Point[] pointArray = GeoLocationService.getExtremePointsFrom(ludwigsburg, 300.0);
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            System.out.println("Extreme Point : " + point);
            System.out.println("Distance from point  : " + DistanceCalculator.distanceBetweenPoints((Position)ludwigsburg, (Position)point, (MeasuringUnit)MeasuringUnit.METER));
            ++n2;
        }
        double distance1 = DistanceCalculator.distanceBetweenPoints((Position)ludwigsburg, (Position)alterTeichweg, (MeasuringUnit)MeasuringUnit.MILE);
        System.out.println("Distance1:" + distance1);
        try {
            String geohashOrgResult = Geocoder.getPlainTextResponse(alterTeichwegGeohash);
            System.out.println("====================================");
            System.out.println(geohashOrgResult);
            System.out.println("====================================");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static double radiansToDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    public static double degreesToRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static double getExtremeLongitudesDiffForPoint(Point p1, double distance) {
        double lat1 = p1.getLatitude();
        lat1 = GeoLocationService.degreesToRadians(lat1);
        double longitudeRadius = Math.cos(lat1) * 6371.009;
        double diffLong = distance / longitudeRadius;
        diffLong = GeoLocationService.radiansToDegrees(diffLong);
        return diffLong;
    }

    public static double getExtremeLatitudesDiffForPoint(Point p1, double distance) {
        double latitudeRadians = distance / 6371.009;
        double diffLat = GeoLocationService.radiansToDegrees(latitudeRadians);
        return diffLat;
    }

    public static Point[] getExtremePointsFrom(Point point, Double distance) {
        double longDiff = GeoLocationService.getExtremeLongitudesDiffForPoint(point, distance);
        double latDiff = GeoLocationService.getExtremeLatitudesDiffForPoint(point, distance);
        Point p1 = new Point(point.getLatitude() - latDiff, point.getLongitude() - longDiff);
        Point p2 = new Point(point.getLatitude() + latDiff, point.getLatitude() + longDiff);
        return new Point[]{p1, p2};
    }

    public static double getDistanceBetweenPoints(Point p1, Point p2, String unit) {
        double theta = p1.getLongitude() - p2.getLongitude();
        double dist = Math.sin(GeoLocationService.degreesToRadians(p1.getLatitude())) * Math.sin(GeoLocationService.degreesToRadians(p2.getLatitude())) + Math.cos(GeoLocationService.degreesToRadians(p1.getLatitude())) * Math.cos(GeoLocationService.degreesToRadians(p2.getLatitude())) * Math.cos(GeoLocationService.degreesToRadians(theta));
        dist = Math.acos(dist);
        dist = GeoLocationService.radiansToDegrees(dist);
        dist = dist * 60.0 * 1.1515;
        if (unit.equals("K")) {
            dist *= 1.609344;
        } else if (unit.equals("M")) {
            dist *= 0.8684;
        }
        return dist;
    }
}

