/*
 * Decompiled with CFR 0.152.
 */
package address.book.factories;

import address.book.model.Addresses;
import address.book.model.Countries;
import address.book.model.Federalstates;
import address.book.model.Zipcodes;
import java.io.Serializable;
import java.math.BigDecimal;

public class AddressBookFactory
implements Serializable {
    private static final AddressBookFactory instance = new AddressBookFactory();
    private static final long serialVersionUID = 1L;

    public static AddressBookFactory getInstance() {
        return instance;
    }

    private AddressBookFactory() {
    }

    public Addresses newAddresses(String addressComment, Federalstates federalstate, String geohash, Integer id, String latitude, String longitude, String street, String streetnumber, Zipcodes zipcode) {
        Addresses addresses = new Addresses();
        addresses.setAddressComment(addressComment);
        addresses.setFederalstate(federalstate);
        addresses.setGeohash(geohash);
        addresses.setId(id);
        addresses.setLatitude(latitude);
        addresses.setLongitude(longitude);
        addresses.setStreet(street);
        addresses.setStreetnumber(streetnumber);
        addresses.setZipcode(zipcode);
        return addresses;
    }

    public Addresses newAddresses(String addressComment, Federalstates federalstate, String geohash, BigDecimal latitude, BigDecimal longitude, String street, String streetnumber, Zipcodes zipcode) {
        String lat = latitude != null ? latitude.toString() : "";
        String lng = longitude != null ? longitude.toString() : "";
        return this.newAddresses(addressComment, federalstate, geohash, null, lat, lng, street, streetnumber, zipcode);
    }

    public Addresses newAddresses(Integer id, String addressComment, Federalstates federalstate, String geohash, BigDecimal latitude, BigDecimal longitude, String street, String streetnumber, Zipcodes zipcode) {
        String lat = latitude != null ? latitude.toString() : "";
        String lng = longitude != null ? longitude.toString() : "";
        return this.newAddresses(addressComment, federalstate, geohash, id, lat, lng, street, streetnumber, zipcode);
    }

    public Countries newCountries(Integer id, String iso3166A2name, String iso3166A3name, String iso3166Number, String name) {
        Countries countries = new Countries();
        countries.setId(id);
        countries.setIso3166A2name(iso3166A2name);
        countries.setIso3166A3name(iso3166A3name);
        countries.setIso3166Number(iso3166Number);
        countries.setName(name);
        return countries;
    }

    public Federalstates newFederalstates(Countries country, Integer id, String iso3166A2code, String name, String subdivisionCategory, String subdivisionName) {
        Federalstates federalstates = new Federalstates();
        federalstates.setCountry(country);
        federalstates.setId(id);
        federalstates.setIso3166A2code(iso3166A2code);
        federalstates.setName(name);
        federalstates.setSubdivisionCategory(subdivisionCategory);
        federalstates.setSubdivisionName(subdivisionName);
        return federalstates;
    }

    public Zipcodes newZipcodes(Integer id, Countries country, String city, String zipcode) {
        Zipcodes zipcodes = this.newZipcodes(country, city, zipcode);
        zipcodes.setId(id);
        return zipcodes;
    }

    public Zipcodes newZipcodes(Countries country, String city, String zipcode) {
        Zipcodes zipcodes = new Zipcodes();
        zipcodes.setCountry(country);
        zipcodes.setCity(city);
        zipcodes.setZipcode(zipcode);
        return zipcodes;
    }
}

