/*
 * Decompiled with CFR 0.152.
 */
package address.book.service;

import address.book.application.model.LocationModel;
import address.book.daos.CountriesDao;
import address.book.model.Addresses;
import address.book.model.Countries;
import address.book.model.Federalstates;
import address.book.model.Zipcodes;
import address.book.service.api.AddressesService;
import address.book.service.api.CountriesService;
import address.book.service.api.FederalstatesService;
import address.book.service.api.ZipcodesService;
import address.book.service.utils.HqlStringCreator;
import hbm.dao.jpa.EntityManagerDao;
import hbm.service.jpa.AbstractBusinessService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="countriesService")
public class CountriesBusinessService
extends AbstractBusinessService<Countries, Integer, CountriesDao>
implements CountriesService {
    private static final long serialVersionUID = 1L;
    @Autowired
    private FederalstatesService federalstatesService;
    @Autowired
    private ZipcodesService zipcodesService;
    @Autowired
    private AddressesService addressesService;

    public AddressesService getAddressesService() {
        return this.addressesService;
    }

    public void setAddressesService(AddressesService addressesService) {
        this.addressesService = addressesService;
    }

    public ZipcodesService getZipcodesService() {
        return this.zipcodesService;
    }

    public void setZipcodesService(ZipcodesService zipcodesService) {
        this.zipcodesService = zipcodesService;
    }

    public FederalstatesService getFederalstatesService() {
        return this.federalstatesService;
    }

    public void setFederalstatesService(FederalstatesService federalstatesService) {
        this.federalstatesService = federalstatesService;
    }

    @Autowired
    public void setCountriesDao(CountriesDao countriesDao) {
        this.setDao((EntityManagerDao)countriesDao);
    }

    @Override
    public Map<Countries, List<Federalstates>> getCountriesToFederalstatesMap() {
        LinkedHashMap<Countries, List<Federalstates>> countriesMap = new LinkedHashMap<Countries, List<Federalstates>>();
        List countries = this.findAll();
        Collections.sort(countries, new Comparator<Countries>(){

            @Override
            public int compare(Countries o1, Countries o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Countries country : countries) {
            List<Federalstates> federalstates = this.federalstatesService.findFederalstatesFromCountry(country);
            countriesMap.put(country, federalstates);
        }
        return countriesMap;
    }

    @Override
    public Map<String, List<String>> getCountriesToFederalstatesAsStringMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Map<Countries, List<Federalstates>> countriesToFederalstatesMap = this.getCountriesToFederalstatesMap();
        for (Map.Entry<Countries, List<Federalstates>> entry : countriesToFederalstatesMap.entrySet()) {
            Countries country = entry.getKey();
            List<Federalstates> federalstates = entry.getValue();
            ArrayList<String> fd = new ArrayList<String>();
            for (Federalstates federalstate : federalstates) {
                fd.add(federalstate.getIso3166A2code());
            }
            map.put(country.getName(), fd);
        }
        return map;
    }

    @Override
    public Map<Countries, List<Zipcodes>> getCountriesToZipcodesMap() {
        LinkedHashMap<Countries, List<Zipcodes>> countriesToZipcodeMap = new LinkedHashMap<Countries, List<Zipcodes>>();
        List countries = this.findAll();
        Collections.sort(countries, new Comparator<Countries>(){

            @Override
            public int compare(Countries o1, Countries o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Countries country : countries) {
            List<Zipcodes> zipcodes = this.zipcodesService.find(country);
            countriesToZipcodeMap.put(country, zipcodes);
        }
        return countriesToZipcodeMap;
    }

    @Override
    public Map<Countries, List<Zipcodes>> getGermanCountriesToZipcodesMap() {
        LinkedHashMap<Countries, List<Zipcodes>> countriesToZipcodeMap = new LinkedHashMap<Countries, List<Zipcodes>>();
        ArrayList<Countries> countries = new ArrayList<Countries>();
        countries.add(this.find("DE"));
        countries.add(this.find("AT"));
        countries.add(this.find("CH"));
        Collections.sort(countries, new Comparator<Countries>(){

            @Override
            public int compare(Countries object, Countries compareWithObject) {
                if (object != null && compareWithObject == null) {
                    return 1;
                }
                if (object == null && compareWithObject != null) {
                    return -1;
                }
                if (object == compareWithObject) {
                    return 0;
                }
                return object.getName().compareTo(compareWithObject.getName());
            }
        });
        for (Countries country : countries) {
            List<Zipcodes> zipcodes = this.zipcodesService.find(country);
            countriesToZipcodeMap.put(country, zipcodes);
        }
        return countriesToZipcodeMap;
    }

    @Override
    public Map<String, List<String>> getGermanCountriesToZipcodesAsStringMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Map<Countries, List<Zipcodes>> countriesToZipcodeMap = this.getGermanCountriesToZipcodesMap();
        for (Map.Entry<Countries, List<Zipcodes>> entry : countriesToZipcodeMap.entrySet()) {
            Countries country = entry.getKey();
            List<Zipcodes> zipcodes = entry.getValue();
            ArrayList<String> zc = new ArrayList<String>();
            for (Zipcodes zipcode : zipcodes) {
                zc.add(zipcode.getZipcode());
            }
            map.put(country.getName(), zc);
        }
        return map;
    }

    @Override
    public Map<String, List<String>> getCountriesToZipcodesAsStringMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Map<Countries, List<Zipcodes>> countriesToZipcodeMap = this.getCountriesToZipcodesMap();
        for (Map.Entry<Countries, List<Zipcodes>> entry : countriesToZipcodeMap.entrySet()) {
            Countries country = entry.getKey();
            List<Zipcodes> zipcodes = entry.getValue();
            ArrayList<String> zc = new ArrayList<String>();
            for (Zipcodes zipcode : zipcodes) {
                zc.add(zipcode.getZipcode());
            }
            map.put(country.getName(), zc);
        }
        return map;
    }

    @Override
    public Map<String, List<String>> getCountriesToZipcodesAndCitiesAsStringMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Map<Countries, List<Zipcodes>> countriesToZipcodeMap = this.getCountriesToZipcodesMap();
        for (Map.Entry<Countries, List<Zipcodes>> entry : countriesToZipcodeMap.entrySet()) {
            Countries country = entry.getKey();
            List<Zipcodes> zipcodes = entry.getValue();
            ArrayList<String> zc = new ArrayList<String>();
            for (Zipcodes zipcode : zipcodes) {
                zc.add(String.valueOf(zipcode.getZipcode()) + " " + zipcode.getCity());
                zc.add(String.valueOf(zipcode.getCity()) + " " + zipcode.getZipcode());
            }
            map.put(country.getName(), zc);
        }
        return map;
    }

    @Override
    public Map<String, List<String>> getGermanCountriesToZipcodesAndCitiesAsStringMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Map<Countries, List<Zipcodes>> countriesToZipcodeMap = this.getGermanCountriesToZipcodesMap();
        for (Map.Entry<Countries, List<Zipcodes>> entry : countriesToZipcodeMap.entrySet()) {
            Countries country = entry.getKey();
            List<Zipcodes> zipcodes = entry.getValue();
            ArrayList<String> zc = new ArrayList<String>();
            for (Zipcodes zipcode : zipcodes) {
                zc.add(String.valueOf(zipcode.getZipcode()) + " " + zipcode.getCity());
                zc.add(String.valueOf(zipcode.getCity()) + " " + zipcode.getZipcode());
            }
            map.put(country.getName(), zc);
        }
        return map;
    }

    @Override
    public List<Countries> findAll(String iso3166A2name, String iso3166A3name, String iso3166Number, String name) {
        String hqlString = HqlStringCreator.forCountries(iso3166A2name, iso3166A3name, iso3166Number, name);
        Query query = this.getQuery(hqlString);
        if (iso3166A2name != null && !iso3166A2name.isEmpty()) {
            query.setParameter("iso3166A2name", (Object)iso3166A2name);
        }
        if (iso3166A3name != null && !iso3166A3name.isEmpty()) {
            query.setParameter("iso3166A3name", (Object)iso3166A3name);
        }
        if (iso3166Number != null && !iso3166Number.isEmpty()) {
            query.setParameter("iso3166Number", (Object)iso3166Number);
        }
        if (name != null && !name.isEmpty()) {
            query.setParameter("name", (Object)name);
        }
        List countries = query.getResultList();
        return countries;
    }

    @Override
    public Countries find(String iso3166A2name) {
        List<Countries> countries = this.findAll(iso3166A2name, null, null, null);
        if (countries != null && !countries.isEmpty()) {
            return countries.get(0);
        }
        return null;
    }

    @Override
    public Countries findByName(String name) {
        List<Countries> countries = this.findAll(null, null, null, name);
        if (countries != null && !countries.isEmpty()) {
            return countries.get(0);
        }
        return null;
    }

    @Override
    public String setLocationModel(LocationModel modelObject, String zc) {
        String errorKey = null;
        if (zc == null) {
            errorKey = "global.location.error.label";
        } else {
            Countries country = this.findByName(modelObject.getSelectedCountryName());
            Zipcodes zipcode = this.getZipcodesService().findCityFromZipcode(country, zc);
            if (zipcode != null) {
                List<Addresses> addresses = this.getAddressesService().find(zipcode);
                Addresses address = null;
                if (addresses != null && !addresses.isEmpty()) {
                    address = addresses.get(0);
                    modelObject.setAddress(address);
                } else {
                    errorKey = "global.location.error.label";
                }
            } else {
                errorKey = "global.location.error.label";
            }
        }
        return errorKey;
    }
}

