/*
 * Decompiled with CFR 0.152.
 */
package address.book.service;

import address.book.daos.FederalstatesDao;
import address.book.model.Countries;
import address.book.model.Federalstates;
import address.book.service.api.FederalstatesService;
import de.alpharogroup.collections.ListExtensions;
import hbm.dao.jpa.EntityManagerDao;
import hbm.service.jpa.AbstractBusinessService;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="federalstatesService")
public class FederalstatesBusinessService
extends AbstractBusinessService<Federalstates, Integer, FederalstatesDao>
implements FederalstatesService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setFederalstatesDao(FederalstatesDao federalstatesDao) {
        this.setDao((EntityManagerDao)federalstatesDao);
    }

    @Override
    public Federalstates findFederalstateFromIso3166A2code(String iso3166A2code) {
        String hqlString = "select fs from Federalstates fs where fs.iso3166A2code=:iso3166A2code";
        Query query = this.getQuery("select fs from Federalstates fs where fs.iso3166A2code=:iso3166A2code");
        query.setParameter("iso3166A2code", (Object)iso3166A2code);
        List federalstates = query.getResultList();
        if (federalstates != null && !federalstates.isEmpty()) {
            federalstates.get(0);
        }
        return null;
    }

    @Override
    public String findFederalstateNameFromIso3166A2code(String iso3166A2code) {
        String hqlString = "select fs.name from Federalstates fs where fs.iso3166A2code=:iso3166A2code";
        Query query = this.getQuery("select fs.name from Federalstates fs where fs.iso3166A2code=:iso3166A2code");
        query.setParameter("iso3166A2code", (Object)iso3166A2code);
        List names = query.getResultList();
        if (names != null && !names.isEmpty()) {
            names.get(0);
        }
        return null;
    }

    @Override
    public List<Federalstates> findFederalstatesFromCountry(Countries country) {
        String hqlString = "select fs from Federalstates fs where fs.country=:country";
        Query query = this.getQuery("select fs from Federalstates fs where fs.country=:country");
        query.setParameter("country", (Object)country);
        List federalstates = query.getResultList();
        return federalstates;
    }

    @Override
    public List<Federalstates> findFederalstatesFromCountry(Countries country, String name) {
        String hqlString = "select fs from Federalstates fs where fs.country=:country and fs.name=:name";
        Query query = this.getQuery("select fs from Federalstates fs where fs.country=:country and fs.name=:name");
        query.setParameter("country", (Object)country);
        query.setParameter("name", (Object)name);
        List federalstates = query.getResultList();
        return federalstates;
    }

    @Override
    public Federalstates findFederalstate(Countries country, String name) {
        return (Federalstates)ListExtensions.getFirst(this.findFederalstatesFromCountry(country, name));
    }

    @Override
    public Federalstates getFederalstate(String string) {
        Federalstates federalstate;
        String seperatedString = "=>";
        String[] splittedString = string.split(seperatedString);
        if (splittedString.length == 1) {
            String coutryString = splittedString[0];
            int dot = coutryString.indexOf(46);
            String iso3166A3code = coutryString.substring(dot + 1, coutryString.length()).toUpperCase();
            federalstate = this.findFederalstateFromIso3166A2code(iso3166A3code);
        } else {
            String federalStateString = splittedString[1];
            federalstate = this.findFederalstateFromIso3166A2code(federalStateString);
        }
        return federalstate;
    }
}

