/*
 * Decompiled with CFR 0.152.
 */
package address.book.service;

import address.book.daos.ZipcodesDao;
import address.book.factories.AddressBookFactory;
import address.book.model.Countries;
import address.book.model.Zipcodes;
import address.book.service.api.ZipcodesService;
import address.book.service.utils.HqlStringCreator;
import hbm.dao.jpa.EntityManagerDao;
import hbm.service.jpa.AbstractBusinessService;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="zipcodesService")
public class ZipcodesBusinessService
extends AbstractBusinessService<Zipcodes, Integer, ZipcodesDao>
implements ZipcodesService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setZipcodesDao(ZipcodesDao zipcodesDao) {
        this.setDao((EntityManagerDao)zipcodesDao);
    }

    @Override
    public void deleteAllZipcodes() {
        List zipcodes = this.findAll();
        for (Zipcodes zipcode : zipcodes) {
            this.delete(zipcode);
        }
    }

    @Override
    public boolean existsZipcode(String zipcode) {
        List<Zipcodes> zipcodes = this.findAll(null, zipcode, null);
        this.findAll(null, zipcode, null);
        return zipcodes != null && !zipcodes.isEmpty();
    }

    @Override
    public List<Zipcodes> findZipcodes(String zipcode) {
        return this.findAll(null, zipcode, null);
    }

    @Override
    public Zipcodes getZipcode(String zipcode, String city) {
        List<Zipcodes> zipcodes = this.findZipcodes(zipcode);
        Zipcodes zc = zipcodes != null && !zipcodes.isEmpty() ? zipcodes.get(0) : AddressBookFactory.getInstance().newZipcodes(null, null, city, zipcode);
        return zc;
    }

    @Override
    public List<Zipcodes> find(Countries country) {
        return this.findAll(country, null, null);
    }

    @Override
    public Zipcodes findCityFromZipcode(Countries country, String zipcode) {
        List<Zipcodes> zipcodes = this.findAll(country, zipcode, null);
        if (zipcodes != null && !zipcodes.isEmpty()) {
            return zipcodes.get(0);
        }
        return null;
    }

    @Override
    public List<Zipcodes> findAll(Countries country, String zipcode, String city) {
        String hqlString = HqlStringCreator.forZipcodes(country, zipcode, city);
        Query query = this.getQuery(hqlString);
        if (country != null) {
            query.setParameter("country", (Object)country);
        }
        if (zipcode != null && !zipcode.isEmpty()) {
            query.setParameter("zipcode", (Object)zipcode);
        }
        if (city != null && !city.isEmpty()) {
            query.setParameter("city", (Object)city);
        }
        List zipcodes = query.getResultList();
        return zipcodes;
    }
}

