/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.design.pattern.builder;

public final class Car {
    private final int constructionYear;
    private final String model;
    private final String type;

    public static Builder builder(String type) {
        return new Builder(type);
    }

    private Car(Builder builder) {
        this.model = builder.model;
        this.type = builder.type;
        this.constructionYear = builder.constructionYear;
    }

    public int getConstructionYear() {
        return this.constructionYear;
    }

    public String getModel() {
        return this.model;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "Car{type='" + this.type + '\'' + ", model='" + this.model + '\'' + ", constructionYear=" + this.constructionYear + '}';
    }

    public static class Builder {
        private int constructionYear;
        private String model;
        private final String type;

        public Builder(String type) {
            this.type = type;
        }

        public Car build() {
            return new Car(this);
        }

        public Builder constructionYear(int constructionYear) {
            this.constructionYear = constructionYear;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }
    }
}

