/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.keyrules;

import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.keyrules.SimpleKeyRule;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Obfuscator {
    private SimpleKeyRule rule;
    private final String key;

    public Obfuscator(SimpleKeyRule rule, String key) {
        Check.get().notNull((Object)rule, "rule");
        Check.get().notEmpty((CharSequence)key, "key");
        this.rule = rule;
        this.key = key;
    }

    public String obfuscate() {
        Map<String, String> rules = this.rule.getRules();
        String clonedKey = this.key;
        for (Map.Entry<String, String> rule : rules.entrySet()) {
            clonedKey = StringUtils.replace((String)clonedKey, (String)rule.getKey(), (String)rule.getValue());
        }
        return clonedKey;
    }

    public String disentangle() {
        String clonedKey = this.obfuscate();
        Map<String, String> rules = this.rule.getRules();
        for (Map.Entry<String, String> rule : rules.entrySet()) {
            clonedKey = StringUtils.replace((String)clonedKey, (String)rule.getValue(), (String)rule.getKey());
        }
        return clonedKey;
    }
}

