/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.sha;

import de.alpharogroup.crypto.aes.HexEncryptor;
import de.alpharogroup.crypto.algorithm.HashAlgorithm;
import de.alpharogroup.random.RandomUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class Hasher {
    public static byte[] getRandomSalt(int length, Charset charset) {
        return RandomUtils.getRandomString((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", (int)length).getBytes(charset);
    }

    public static String hash(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
        messageDigest.reset();
        messageDigest.update(salt.getBytes(charset));
        return new String(messageDigest.digest(hashIt.getBytes(charset)), charset);
    }

    public static String hashAndBase64(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        String hashedAndBase64 = new Base64().encodeToString(Hasher.hash(hashIt, salt, hashAlgorithm, charset).getBytes(charset));
        return hashedAndBase64;
    }

    public static String hashAndHex(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        HexEncryptor hexEncryptor = new HexEncryptor();
        return hexEncryptor.encrypt(Hasher.hash(hashIt, salt, hashAlgorithm, charset));
    }
}

