/**
 * Copyright (C) 2015 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.crypto.interfaces;

/**
 * Generic interface for decrypt objects.
 *
 * @author Asterios Raptis
 * @version 1.0
 * @param <T> the generic type of the input to decrypt
 * @param <R> the generic type of the result
 */
public interface GenericDecryptor<T,R>
{

	/**
	 * Decrypt the given encrypted object.
	 *
	 * @param encypted
	 *            The object to decrypt.
	 * @return The decrypted object
	 * @throws Exception
	 *             is thrown if decryption fails.
	 */
	public R decrypt(final T encypted) throws Exception;

}
