/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.processors.wordlist;

import de.alpharogroup.check.Check;
import java.util.List;

public class WordlistsProcessor {
    private final List<String> words;
    private int currentIndex;
    private String toCheckAgainst;

    public WordlistsProcessor(List<String> words) {
        this.words = words;
        this.currentIndex = 0;
    }

    public WordlistsProcessor(List<String> words, String toCheckAgainst) {
        Check.get().notNull((Object)toCheckAgainst, "toCheckAgainst").notEmpty((CharSequence)toCheckAgainst, "toCheckAgainst");
        this.words = words;
        this.currentIndex = 0;
        this.toCheckAgainst = toCheckAgainst;
    }

    public String getCurrentAttempt() {
        if (this.currentIndex < this.words.size()) {
            String currentAttempt = this.words.get(this.currentIndex);
            return currentAttempt;
        }
        return null;
    }

    public boolean increment() {
        if (this.currentIndex == this.words.size()) {
            return false;
        }
        ++this.currentIndex;
        return true;
    }

    public boolean process() {
        boolean continueIterate = true;
        boolean found = false;
        String attempt = this.getCurrentAttempt();
        while (continueIterate) {
            if (attempt.equals(this.toCheckAgainst)) {
                System.out.println("Password Found: " + attempt);
                found = true;
                break;
            }
            attempt = this.getCurrentAttempt();
            System.out.println("Tried: " + attempt);
            continueIterate = this.increment();
        }
        return found;
    }

    public String getToCheckAgainst() {
        return this.toCheckAgainst;
    }

    public void setToCheckAgainst(String toCheckAgainst) {
        this.toCheckAgainst = toCheckAgainst;
    }
}

