/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.aes;

import de.alpharogroup.crypto.interfaces.Decryptor;
import java.util.Arrays;

public class ChainedDecryptor
implements Decryptor<String, String> {
    private final Decryptor<String, String>[] decryptors;

    @SafeVarargs
    public ChainedDecryptor(Decryptor<String, String> ... decryptors) {
        this.decryptors = decryptors;
    }

    @Override
    public String decrypt(String encypted) throws Exception {
        String result = encypted;
        for (Decryptor<String, String> encryptor : this.decryptors) {
            result = encryptor.decrypt(result);
        }
        return result;
    }

    public static ChainedDecryptorBuilder builder() {
        return new ChainedDecryptorBuilder();
    }

    public Decryptor<String, String>[] getDecryptors() {
        return this.decryptors;
    }

    public static class ChainedDecryptorBuilder {
        private Decryptor<String, String>[] decryptors;

        ChainedDecryptorBuilder() {
        }

        public ChainedDecryptorBuilder decryptors(Decryptor<String, String>[] decryptors) {
            this.decryptors = decryptors;
            return this;
        }

        public ChainedDecryptor build() {
            return new ChainedDecryptor(this.decryptors);
        }

        public String toString() {
            return "ChainedDecryptor.ChainedDecryptorBuilder(decryptors=" + Arrays.deepToString(this.decryptors) + ")";
        }
    }
}

