/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.aes;

import de.alpharogroup.crypto.interfaces.Encryptor;
import java.util.Arrays;

public class ChainedEncryptor
implements Encryptor<String, String> {
    private final Encryptor<String, String>[] encryptors;

    @SafeVarargs
    public ChainedEncryptor(Encryptor<String, String> ... encryptors) {
        this.encryptors = encryptors;
    }

    @Override
    public String encrypt(String string) throws Exception {
        String result = string;
        for (Encryptor<String, String> encryptor : this.encryptors) {
            result = encryptor.encrypt(result);
        }
        return result;
    }

    public static ChainedEncryptorBuilder builder() {
        return new ChainedEncryptorBuilder();
    }

    public Encryptor<String, String>[] getEncryptors() {
        return this.encryptors;
    }

    public static class ChainedEncryptorBuilder {
        private Encryptor<String, String>[] encryptors;

        ChainedEncryptorBuilder() {
        }

        public ChainedEncryptorBuilder encryptors(Encryptor<String, String>[] encryptors) {
            this.encryptors = encryptors;
            return this;
        }

        public ChainedEncryptor build() {
            return new ChainedEncryptor(this.encryptors);
        }

        public String toString() {
            return "ChainedEncryptor.ChainedEncryptorBuilder(encryptors=" + Arrays.deepToString(this.encryptors) + ")";
        }
    }
}

