/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.aes;

import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.aes.HexDump;
import de.alpharogroup.crypto.algorithm.AesAlgorithm;
import de.alpharogroup.crypto.algorithm.Algorithm;
import de.alpharogroup.crypto.core.BaseStringDecryptor;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class HexDecryptor
extends BaseStringDecryptor {
    private static final long serialVersionUID = 1L;

    public HexDecryptor(String privateKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(privateKey, AesAlgorithm.AES);
    }

    public HexDecryptor(String privateKey, Algorithm algorithm) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(privateKey);
        Check.get().notNull((Object)algorithm, "algorithm");
        this.getModel().setAlgorithm(algorithm);
    }

    @Override
    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            this.getModel().setAlgorithm(AesAlgorithm.AES);
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    @Override
    protected Cipher newCipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        SecretKeySpec skeySpec = new SecretKeySpec(privateKey.getBytes("UTF-8"), this.getModel().getAlgorithm().getAlgorithm());
        Cipher cipher = Cipher.getInstance(this.getModel().getAlgorithm().getAlgorithm());
        cipher.init(operationMode, skeySpec);
        return cipher;
    }

    @Override
    public String decrypt(String encypted) throws Exception {
        byte[] dec = HexDump.decodeHex(encypted.toCharArray());
        byte[] utf8 = ((Cipher)this.getModel().getCipher()).doFinal(dec);
        return new String(utf8, "UTF-8");
    }
}

