/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.factories;

import de.alpharogroup.crypto.algorithm.Algorithm;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;

public final class KeyPairFactory {
    public static KeyPair newKeyPair(Algorithm algorithm, int keySize) throws NoSuchAlgorithmException {
        return KeyPairFactory.newKeyPair(algorithm.getAlgorithm(), keySize);
    }

    public static KeyPair newKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairFactory.newKeyPairGenerator(algorithm, keySize);
        return generator.generateKeyPair();
    }

    public static KeyPairGenerator newKeyPairGenerator(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm);
        generator.initialize(keySize);
        return generator;
    }

    private KeyPairFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

