/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;

public final class PrivateKeyExtensions {
    public static int getKeyLength(PrivateKey privateKey) {
        int length = -1;
        if (privateKey == null) {
            return length;
        }
        if (privateKey instanceof RSAPrivateKey) {
            length = ((RSAPrivateKey)privateKey).getModulus().bitLength();
        }
        if (privateKey instanceof DSAPrivateKey) {
            length = ((DSAPrivateKey)privateKey).getParams().getQ().bitLength();
        }
        if (privateKey instanceof ECPrivateKey) {
            length = ((ECPrivateKey)privateKey).getParams().getCurve().getField().getFieldSize();
        }
        return length;
    }

    private PrivateKeyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

