/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;

public final class PublicKeyExtensions {
    public static int getKeyLength(PublicKey publicKey) {
        int length = -1;
        if (publicKey == null) {
            return length;
        }
        if (publicKey instanceof RSAPublicKey) {
            length = ((RSAPublicKey)publicKey).getModulus().bitLength();
        }
        if (publicKey instanceof DSAPublicKey) {
            length = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (publicKey instanceof ECPublicKey) {
            length = ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        }
        return length;
    }

    private PublicKeyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

