/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.aes;

import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.algorithm.AesAlgorithm;
import de.alpharogroup.crypto.algorithm.Algorithm;
import de.alpharogroup.crypto.core.BaseStringEncryptor;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class HexEncryptor
extends BaseStringEncryptor {
    private static final long serialVersionUID = 1L;

    public HexEncryptor(String privateKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(privateKey, (Algorithm)AesAlgorithm.AES);
    }

    public HexEncryptor(String privateKey, Algorithm algorithm) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(privateKey);
        Check.get().notNull((Object)algorithm, "algorithm");
        this.getModel().setAlgorithm(algorithm);
    }

    @Override
    public String encrypt(String string) throws InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        byte[] utf8 = string.getBytes("UTF-8");
        byte[] encrypt = ((Cipher)this.getModel().getCipher()).doFinal(utf8);
        char[] original = Hex.encodeHex((byte[])encrypt, (boolean)false);
        return new String(original);
    }

    @Override
    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            this.getModel().setAlgorithm((Algorithm)AesAlgorithm.AES);
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    @Override
    protected Cipher newCipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        SecretKeySpec skeySpec = new SecretKeySpec(privateKey.getBytes("UTF-8"), this.getModel().getAlgorithm().getAlgorithm());
        Cipher cipher = Cipher.getInstance(this.getModel().getAlgorithm().getAlgorithm());
        cipher.init(operationMode, skeySpec);
        return cipher;
    }
}

