/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.algorithm.KeyPairWithModeAndPaddingAlgorithm;
import de.alpharogroup.crypto.core.AbstractCryptor;
import de.alpharogroup.crypto.factories.CipherFactory;
import de.alpharogroup.crypto.interfaces.ByteArrayEncryptor;
import de.alpharogroup.crypto.model.CryptModel;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class PublicKeyEncryptor
extends AbstractCryptor<Cipher, PublicKey>
implements ByteArrayEncryptor {
    private static final long serialVersionUID = 1L;

    public PublicKeyEncryptor(CryptModel<Cipher, PublicKey> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    @Override
    public byte[] encrypt(byte[] toEncrypt) throws Exception {
        byte[] encrypted = ((Cipher)this.getModel().getCipher()).doFinal(toEncrypt);
        return encrypted;
    }

    @Override
    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            return KeyPairWithModeAndPaddingAlgorithm.RSA_ECB_OAEPWithSHA1AndMGF1Padding.getAlgorithm();
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    @Override
    protected Cipher newCipher(PublicKey key, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        Cipher cipher = CipherFactory.newCipher((String)algorithm);
        cipher.init(operationMode, key);
        return cipher;
    }
}

