/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.simple;

import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.CryptConst;
import de.alpharogroup.crypto.interfaces.StringEncryptor;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;

public class SimpleEncryptor
implements StringEncryptor {
    private Cipher cipher;
    private final String privateKey;
    private boolean initialized;

    public SimpleEncryptor(String privateKey) {
        Check.get().notEmpty((CharSequence)privateKey, "privateKey");
        this.privateKey = privateKey;
    }

    @Override
    public String encrypt(String string) throws UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        this.initialize();
        byte[] utf8 = string.getBytes("UTF8");
        byte[] encrypt = this.cipher.doFinal(utf8);
        String encrypted = new Base64().encodeToString(encrypt);
        return encrypted;
    }

    private void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            PBEKeySpec keySpec = this.getPrivateKey() != null ? new PBEKeySpec(this.getPrivateKey().toCharArray()) : new PBEKeySpec("privattop secret".toCharArray());
            SecretKeyFactory factory = SecretKeyFactory.getInstance(CryptConst.PBE_WITH_MD5_AND_DES);
            SecretKey key = factory.generateSecret(keySpec);
            this.cipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(CryptConst.SALT, 19);
            this.cipher.init(this.newOperationMode(), (Key)key, paramSpec);
            this.initialized = true;
        }
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    private boolean isInitialized() {
        return this.initialized;
    }
}

