/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.algorithm.KeyPairGeneratorAlgorithm;
import de.alpharogroup.crypto.provider.SecurityProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

@Deprecated
public final class KeyExtensions {
    public static final int AES_KEY_LENGTH = 256;
    public static final String END_PUBLIC_KEY_SUFFIX = "-----END PUBLIC KEY-----";
    public static final String BEGIN_PUBLIC_KEY_PREFIX = "-----BEGIN PUBLIC KEY-----\n";
    public static final String END_PRIVATE_KEY_SUFFIX = "-----END PRIVATE KEY-----";
    public static final String BEGIN_PRIVATE_KEY_PREFIX = "-----BEGIN PRIVATE KEY-----";
    public static final String END_RSA_PRIVATE_KEY_SUFFIX = "\n-----END RSA PRIVATE KEY-----";
    public static final String BEGIN_RSA_PRIVATE_KEY_PREFIX = "-----BEGIN RSA PRIVATE KEY-----\n";

    public static PemObject getPemObject(File file) throws IOException {
        PemObject pemObject;
        try (PemReader pemReader = new PemReader((Reader)new InputStreamReader(new FileInputStream(file)));){
            pemObject = pemReader.readPemObject();
        }
        return pemObject;
    }

    public static PublicKey readPublicKey(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        return KeyExtensions.readPublicKey(keyBytes, "BC");
    }

    public static PublicKey readPublicKey(byte[] publicKeyBytes, SecurityProvider securityProvider) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return KeyExtensions.readPublicKey(publicKeyBytes, securityProvider.name());
    }

    public static PublicKey readPublicKey(byte[] publicKeyBytes, String provider) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey readPrivateKey(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        return KeyExtensions.readPrivateKey(keyBytes, "BC");
    }

    public static PrivateKey readPrivateKey(byte[] privateKeyBytes, String provider) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static PrivateKey readPemPrivateKey(File file, SecurityProvider securityProvider) throws Exception {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        String privateKeyAsString = new String(keyBytes).replace(BEGIN_RSA_PRIVATE_KEY_PREFIX, "").replace(END_RSA_PRIVATE_KEY_SUFFIX, "").trim();
        byte[] decoded = new Base64().decode(privateKeyAsString);
        return KeyExtensions.readPrivateKey(decoded, securityProvider);
    }

    public static PrivateKey readPrivateKey(byte[] privateKeyBytes, SecurityProvider securityProvider) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return KeyExtensions.readPrivateKey(privateKeyBytes, securityProvider.name());
    }

    public static PublicKey readPemPublicKey(File file, SecurityProvider securityProvider) throws Exception {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        String publicKeyAsString = new String(keyBytes).replace(BEGIN_PUBLIC_KEY_PREFIX, "").replace(END_PUBLIC_KEY_SUFFIX, "");
        byte[] decoded = Base64.decodeBase64((String)publicKeyAsString);
        return KeyExtensions.readPublicKey(decoded, securityProvider);
    }

    public static PublicKey readPemPublicKey(File file) throws Exception {
        return KeyExtensions.readPemPublicKey(file, SecurityProvider.BC);
    }

    private KeyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

