/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.sha;

import de.alpharogroup.crypto.algorithm.HashAlgorithm;
import de.alpharogroup.crypto.hex.HexableEncryptor;
import de.alpharogroup.random.RandomExtensions;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public final class Hasher {
    public static byte[] getRandomSalt(int length, Charset charset) {
        return RandomExtensions.getRandomString((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", (int)length).getBytes(charset);
    }

    public static String hash(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
        messageDigest.reset();
        messageDigest.update(salt.getBytes(charset));
        return new String(messageDigest.digest(hashIt.getBytes(charset)), charset);
    }

    public static String hashAndBase64(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        String hashedAndBase64 = new Base64().encodeToString(Hasher.hash(hashIt, salt, hashAlgorithm, charset).getBytes(charset));
        return hashedAndBase64;
    }

    public static String hashAndHex(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException {
        HexableEncryptor hexEncryptor = new HexableEncryptor("privattop secret");
        return hexEncryptor.encrypt(Hasher.hash(hashIt, salt, hashAlgorithm, charset));
    }

    private Hasher() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

