/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.core;

import de.alpharogroup.crypto.interfaces.Encryptor;

public abstract class ChainableEncryptor<T>
implements Encryptor<T, T> {
    private final Encryptor<T, T>[] encryptors;

    @SafeVarargs
    public ChainableEncryptor(Encryptor<T, T> ... encryptors) {
        this.encryptors = encryptors;
    }

    @Override
    public T encrypt(T toEncrypt) throws Exception {
        T result = toEncrypt;
        for (Encryptor<T, T> encryptor : this.encryptors) {
            result = encryptor.encrypt(result);
        }
        return result;
    }

    public Encryptor<T, T>[] getEncryptors() {
        return this.encryptors;
    }
}

