/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.core;

import de.alpharogroup.crypto.core.AbstractEncryptor;
import de.alpharogroup.crypto.factories.CipherFactory;
import de.alpharogroup.crypto.factories.KeySpecFactory;
import de.alpharogroup.crypto.interfaces.StringEncryptor;
import de.alpharogroup.crypto.model.CryptModel;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public abstract class AbstractStringEncryptor
extends AbstractEncryptor<Cipher, String>
implements StringEncryptor {
    private static final long serialVersionUID = 1L;

    public AbstractStringEncryptor(CryptModel<Cipher, String> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public AbstractStringEncryptor(String privateKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(privateKey);
    }

    protected Cipher newCipher(int operationMode, SecretKey key, AlgorithmParameterSpec paramSpec, String alg) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return CipherFactory.newCipher((int)operationMode, (SecretKey)key, (AlgorithmParameterSpec)paramSpec, (String)alg);
    }

    @Override
    protected Cipher newCipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        KeySpec keySpec = this.newKeySpec(privateKey, salt, iterationCount);
        SecretKeyFactory factory = this.newSecretKeyFactory(algorithm);
        SecretKey key = factory.generateSecret(keySpec);
        AlgorithmParameterSpec paramSpec = this.newAlgorithmParameterSpec(salt, iterationCount);
        return this.newCipher(operationMode, key, paramSpec, key.getAlgorithm());
    }

    protected KeySpec newKeySpec(String privateKey, byte[] salt, int iterationCount) {
        return KeySpecFactory.newPBEKeySpec((String)privateKey, (byte[])salt, (int)iterationCount);
    }
}

