/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.hex;

import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.algorithm.AesAlgorithm;
import de.alpharogroup.crypto.algorithm.Algorithm;
import de.alpharogroup.crypto.core.AbstractStringDecryptor;
import de.alpharogroup.crypto.factories.SecretKeyFactoryExtensions;
import de.alpharogroup.crypto.hex.HexExtensions;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class HexableDecryptor
extends AbstractStringDecryptor {
    private static final long serialVersionUID = 1L;

    public HexableDecryptor(String privateKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this(privateKey, (Algorithm)AesAlgorithm.AES);
    }

    public HexableDecryptor(String privateKey, Algorithm algorithm) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(privateKey);
        Check.get().notNull((Object)algorithm, "algorithm");
        this.getModel().setAlgorithm(algorithm);
    }

    @Override
    public String decrypt(String encypted) throws Exception {
        byte[] dec = HexExtensions.decodeHex((char[])encypted.toCharArray());
        byte[] utf8 = ((Cipher)this.getModel().getCipher()).doFinal(dec);
        return new String(utf8, "UTF-8");
    }

    @Override
    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            this.getModel().setAlgorithm((Algorithm)AesAlgorithm.AES);
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    @Override
    protected Cipher newCipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        SecretKeySpec skeySpec = SecretKeyFactoryExtensions.newSecretKeySpec((byte[])privateKey.getBytes("UTF-8"), (String)algorithm);
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(operationMode, skeySpec);
        return cipher;
    }
}

