/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.algorithm.KeyPairGeneratorAlgorithm;
import de.alpharogroup.crypto.provider.SecurityProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

@Deprecated
public final class KeyExtensions {
    public static final int AES_KEY_LENGTH = 256;
    public static final String END_CERTIFICATE_SUFFIX = "-----END CERTIFICATE-----";
    public static final String BEGIN_CERTIFICATE_PREFIX = "-----BEGIN CERTIFICATE-----\n";
    public static final String END_PUBLIC_KEY_SUFFIX = "-----END PUBLIC KEY-----";
    public static final String BEGIN_PUBLIC_KEY_PREFIX = "-----BEGIN PUBLIC KEY-----\n";
    public static final String END_PRIVATE_KEY_SUFFIX = "-----END PRIVATE KEY-----";
    public static final String BEGIN_PRIVATE_KEY_PREFIX = "-----BEGIN PRIVATE KEY-----";
    public static final String END_RSA_PRIVATE_KEY_SUFFIX = "\n-----END RSA PRIVATE KEY-----";
    public static final String BEGIN_RSA_PRIVATE_KEY_PREFIX = "-----BEGIN RSA PRIVATE KEY-----\n";

    public static PublicKey readPublicKey(byte[] publicKeyBytes, SecurityProvider securityProvider) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return KeyExtensions.readPublicKey(publicKeyBytes, securityProvider.name());
    }

    public static PublicKey readPublicKey(byte[] publicKeyBytes, String provider) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PrivateKey readPKCS8EncodedPrivateKey(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        return KeyExtensions.readPKCS8EncodedPrivateKey(keyBytes, "BC");
    }

    public static PrivateKey readPKCS8EncodedPrivateKey(byte[] privateKeyBytes, String provider) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    private KeyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

