/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.gm;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class GoogleMapsUrlSigner {
    public static byte[] convertToKeyByteArray(String yourGooglePrivateKeyString) {
        yourGooglePrivateKeyString = yourGooglePrivateKeyString.replace('-', '+');
        yourGooglePrivateKeyString = yourGooglePrivateKeyString.replace('_', '/');
        return Base64.getDecoder().decode(yourGooglePrivateKeyString);
    }

    public static String signRequest(String yourGooglePrivateKeyString, String path, String query) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, URISyntaxException {
        String resource = path + '?' + query;
        SecretKeySpec sha1Key = new SecretKeySpec(GoogleMapsUrlSigner.convertToKeyByteArray(yourGooglePrivateKeyString), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(sha1Key);
        byte[] sigBytes = mac.doFinal(resource.getBytes());
        String signature = Base64.getEncoder().encodeToString(sigBytes);
        signature = signature.replace('+', '-');
        signature = signature.replace('/', '_');
        return resource + "&signature=" + signature;
    }

    public static String signRequest(URL url, String yourGooglePrivateKeyString) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, URISyntaxException {
        String resource = url.getPath() + '?' + url.getQuery();
        SecretKeySpec sha1Key = new SecretKeySpec(GoogleMapsUrlSigner.convertToKeyByteArray(yourGooglePrivateKeyString), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(sha1Key);
        byte[] sigBytes = mac.doFinal(resource.getBytes());
        String signature = Base64.getEncoder().encodeToString(sigBytes);
        signature = signature.replace('+', '-');
        signature = signature.replace('/', '_');
        String signedRequestPath = resource + "&signature=" + signature;
        String urlGoogleMapSignedRequest = url.getProtocol() + "://" + url.getHost() + signedRequestPath;
        return urlGoogleMapSignedRequest;
    }
}

