/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.pw;

import de.alpharogroup.crypto.algorithm.HashAlgorithm;
import de.alpharogroup.crypto.sha.Hasher;
import de.alpharogroup.random.RandomObjectsExtensions;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class PasswordEncryptor
implements Serializable {
    private static final long serialVersionUID = -4667877106378932018L;
    private static final PasswordEncryptor instance = new PasswordEncryptor();
    private final HashAlgorithm DEFAULT_ALGORITHM = HashAlgorithm.SHA_512;
    private final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public static PasswordEncryptor getInstance() {
        return instance;
    }

    private PasswordEncryptor() {
    }

    public String getRandomPassword(int length) {
        return RandomObjectsExtensions.getRandomPassword((int)length);
    }

    public String getRandomSalt(int length) {
        return new String(Hasher.getRandomSalt(length, this.DEFAULT_CHARSET), this.DEFAULT_CHARSET);
    }

    public String hashAndHexPassword(String password, String salt) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        return this.hashAndHexPassword(password, salt, this.DEFAULT_ALGORITHM, this.DEFAULT_CHARSET);
    }

    public String hashAndHexPassword(String password, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        String hashedPassword = Hasher.hashAndHex(password, salt, hashAlgorithm, charset);
        return hashedPassword;
    }

    public String hashPassword(String password, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        String hashedPassword = Hasher.hash(password, salt, hashAlgorithm, charset);
        return hashedPassword;
    }

    public boolean match(String hashedPassword, String dbHashedPassword) {
        return hashedPassword.equals(dbHashedPassword);
    }
}

