/**
 * Copyright (C) 2015 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.crypto.simple;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;

import javax.crypto.NoSuchPaddingException;

import de.alpharogroup.crypto.core.BaseEncryptor;

public class SimpleBaseEncryptor extends BaseEncryptor<Integer, Integer>
{

	private static final long serialVersionUID = 1L;

	public SimpleBaseEncryptor(final String privateKey)
		throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException,
		NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException
	{
		super(privateKey);
	}

	@Override
	public Integer encrypt(final Integer toEncrypt) throws Exception
	{
		final byte[] buf = new byte[1];
        buf[0] = (byte)(toEncrypt.intValue());
        final byte[] utf8 = this.cipher.doFinal(buf);
		return (int)utf8[0];
	}

}
