/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.aes;

import de.alpharogroup.crypto.interfaces.Encryptor;
import java.util.Arrays;

public class ChainedEncryptor
implements Encryptor {
    private final Encryptor[] encryptors;

    public ChainedEncryptor(Encryptor ... encryptors) {
        this.encryptors = encryptors;
    }

    @Override
    public String encrypt(String string) throws Exception {
        String result = string;
        for (Encryptor encryptor : this.encryptors) {
            result = (String)encryptor.encrypt(result);
        }
        return result;
    }

    public static ChainedEncryptorBuilder builder() {
        return new ChainedEncryptorBuilder();
    }

    public Encryptor[] getEncryptors() {
        return this.encryptors;
    }

    public static class ChainedEncryptorBuilder {
        private Encryptor[] encryptors;

        ChainedEncryptorBuilder() {
        }

        public ChainedEncryptorBuilder encryptors(Encryptor[] encryptors) {
            this.encryptors = encryptors;
            return this;
        }

        public ChainedEncryptor build() {
            return new ChainedEncryptor(this.encryptors);
        }

        public String toString() {
            return "ChainedEncryptor.ChainedEncryptorBuilder(encryptors=" + Arrays.deepToString(this.encryptors) + ")";
        }
    }
}

