/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.core;

import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.CryptConst;
import de.alpharogroup.crypto.factories.AlgorithmParameterSpecFactory;
import de.alpharogroup.crypto.factories.CipherFactory;
import de.alpharogroup.crypto.factories.KeySpecFactory;
import de.alpharogroup.crypto.factories.SecretKeyFactoryExtensions;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public abstract class AbstractCryptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Cipher cipher;
    private final String privateKey;
    private boolean initialized;

    public AbstractCryptor(String privateKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        Check.get().notEmpty((CharSequence)privateKey, "privateKey");
        this.privateKey = privateKey;
        this.onInitialize();
    }

    protected void onInitialize() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        this.cipher = this.newCipher(this.privateKey);
        this.initialized = true;
    }

    protected Cipher newCipher(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        return this.newCipher(privateKey, this.newAlgorithm(), this.newSalt(), this.newIterationCount(), this.newOperationMode());
    }

    protected String newAlgorithm() {
        return "PBEWithMD5AndDES";
    }

    protected byte[] newSalt() {
        return CryptConst.SALT;
    }

    protected int newIterationCount() {
        return 19;
    }

    protected abstract int newOperationMode();

    protected Cipher newCipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        KeySpec keySpec = this.newKeySpec(privateKey, salt, iterationCount);
        SecretKeyFactory factory = this.newSecretKeyFactory(algorithm);
        SecretKey key = factory.generateSecret(keySpec);
        AlgorithmParameterSpec paramSpec = this.newAlgorithmParameterSpec(salt, iterationCount);
        return this.newCipher(operationMode, key, paramSpec, key.getAlgorithm());
    }

    protected Cipher newCipher(int operationMode, SecretKey key, AlgorithmParameterSpec paramSpec, String alg) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return CipherFactory.newCipher(operationMode, key, paramSpec, alg);
    }

    protected AlgorithmParameterSpec newAlgorithmParameterSpec(byte[] salt, int iterationCount) {
        return AlgorithmParameterSpecFactory.newPBEParameterSpec(salt, iterationCount);
    }

    protected KeySpec newKeySpec(String privateKey, byte[] salt, int iterationCount) {
        return KeySpecFactory.newPBEKeySpec(privateKey, salt, iterationCount);
    }

    protected SecretKeyFactory newSecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        return SecretKeyFactoryExtensions.newSecretKeyFactory(algorithm);
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    private boolean isInitialized() {
        return this.initialized;
    }
}

