/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation;

import com.google.common.collect.BiMap;
import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.obfuscation.api.Obfuscatable;
import de.alpharogroup.crypto.obfuscation.rule.ObfuscationOperationRule;
import de.alpharogroup.crypto.obfuscation.rule.Operation;
import java.util.Set;

public class CharacterObfuscator
implements Obfuscatable {
    private final BiMap<Character, ObfuscationOperationRule<Character, Character>> rules;
    private final String key;

    public static String obfuscateWith(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String toObfuscate) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toObfuscate.length(); ++i) {
            char currentCharacter = toObfuscate.charAt(i);
            Character asCharacter = Character.valueOf(currentCharacter);
            String charAsString = Character.toString(currentCharacter);
            if (rules.containsKey((Object)asCharacter)) {
                ObfuscationOperationRule obfuscationOperationRule = (ObfuscationOperationRule)rules.get((Object)asCharacter);
                Set indexes = obfuscationOperationRule.getIndexes();
                Operation operation = obfuscationOperationRule.getOperation();
                if (indexes.contains(i) && operation != null) {
                    sb.append(Operation.operate((char)currentCharacter, (Operation)operation));
                    continue;
                }
                Character replaceWith = (Character)obfuscationOperationRule.getReplaceWith();
                sb.append(replaceWith);
                continue;
            }
            sb.append(charAsString);
        }
        return sb.toString();
    }

    public CharacterObfuscator(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String key) {
        Check.get().notEmpty(rules, "rules");
        Check.get().notEmpty((CharSequence)key, "key");
        this.rules = rules;
        this.key = key;
    }

    public String disentangle() {
        String obfuscated = CharacterObfuscator.obfuscateWith(this.rules, this.key);
        String disentangled = this.disentangleWith(this.rules, obfuscated);
        return disentangled;
    }

    private String disentangleWith(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String obfuscated) {
        BiMap inverse = rules.inverse();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < obfuscated.length(); ++i) {
            char currentCharacter = obfuscated.charAt(i);
            Character asCharacter = Character.valueOf(currentCharacter);
            ObfuscationOperationRule<Character, Character> obfuscationOperationRule = this.get((BiMap<ObfuscationOperationRule<Character, Character>, Character>)inverse, asCharacter, i);
            if (obfuscationOperationRule != null) {
                Set indexes = obfuscationOperationRule.getIndexes();
                Operation operation = obfuscationOperationRule.getOperation();
                Character character = (Character)obfuscationOperationRule.getCharacter();
                if (indexes.contains(i) && operation != null) {
                    sb.append(Operation.operate((char)currentCharacter, (Operation)operation, (boolean)true));
                    continue;
                }
                sb.append(character);
                continue;
            }
            sb.append(currentCharacter);
        }
        return sb.toString();
    }

    private ObfuscationOperationRule<Character, Character> get(BiMap<ObfuscationOperationRule<Character, Character>, Character> inverse, Character found, int index) {
        for (ObfuscationOperationRule obfuscationOperationRule : inverse.keySet()) {
            Character operated;
            Set indexes = obfuscationOperationRule.getIndexes();
            Operation operation = obfuscationOperationRule.getOperation();
            Character character = (Character)obfuscationOperationRule.getCharacter();
            if (indexes.contains(index) && operation != null && (operated = Operation.operate((char)found.charValue(), (Operation)operation, (boolean)true)).equals(character)) {
                return obfuscationOperationRule;
            }
            Character replaceWith = (Character)obfuscationOperationRule.getReplaceWith();
            if (!replaceWith.equals(found)) continue;
            return obfuscationOperationRule;
        }
        return null;
    }

    public String obfuscate() {
        String obfuscated = CharacterObfuscator.obfuscateWith(this.rules, this.key);
        return obfuscated;
    }
}

