/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.simple;

import de.alpharogroup.check.Check;
import de.alpharogroup.crypto.CryptConst;
import de.alpharogroup.crypto.api.Cryptor;
import de.alpharogroup.crypto.api.StringDecryptor;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;

public class SimpleDecryptor
implements StringDecryptor,
Cryptor {
    private Cipher cipher;
    private final String privateKey;
    private boolean initialized;

    public SimpleDecryptor(String privateKey) {
        Check.get().notEmpty((CharSequence)privateKey, "privateKey");
        this.privateKey = privateKey;
    }

    public String decrypt(String encypted) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        this.initialize();
        byte[] dec = Base64.decodeBase64((String)encypted);
        byte[] utf8 = this.cipher.doFinal(dec);
        return new String(utf8, "UTF8");
    }

    private void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            PBEKeySpec keySpec = null;
            if (this.getPrivateKey() != null) {
                keySpec = new PBEKeySpec(this.getPrivateKey().toCharArray());
            }
            if (this.getPrivateKey() == null) {
                keySpec = new PBEKeySpec("privattop secret".toCharArray());
            }
            SecretKeyFactory factory = SecretKeyFactory.getInstance(CryptConst.PBE_WITH_MD5_AND_DES);
            SecretKey key = factory.generateSecret(keySpec);
            this.cipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(CryptConst.SALT, 19);
            this.cipher.init(this.newOperationMode(), (Key)key, paramSpec);
            this.initialized = true;
        }
    }

    public int newOperationMode() {
        return 2;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    private boolean isInitialized() {
        return this.initialized;
    }
}

